/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import java.util.Vector;

public class Task
extends Thread {
    private Context context;
    private Vector<Action> actions;
    private Builder builder = null;
    private boolean flagValidator = false;

    public Task() {
        this.flagValidator = true;
    }

    public Task(Context context, Action action, boolean now) throws Exception {
        this.context = context;
        this.actions = new Vector();
        this.actions.add(action);
        this.perform(now);
    }

    public Task(Context context, Vector<Action> actions, boolean now) throws Exception {
        this.context = context;
        this.actions = actions;
        this.perform(now);
    }

    public static Builder factoryRunner(Context context, Action action) throws Exception {
        Task task = new Task();
        task.context = context;
        task.actions = new Vector();
        task.actions.add(action);
        task.run();
        return task.builder;
    }

    private void perform(boolean now) throws Exception {
        if (this.context.isTaskRunning()) {
            throw new Exception("There is already a running task (" + (Object)((Object)this.context.getAction()) + ")");
        }
        if (now) {
            this.run();
        } else {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ThreadProgressBar progressBar = null;
        progressBar = new ThreadProgressBar(this.context);
        progressBar.start();
        try {
            if (!this.flagValidator) {
                this.context.setTaskRunning(true);
            }
            for (Action a : this.actions) {
                if (this.context.isTaskAborting()) break;
                this.context.running((Object)((Object)a) + "");
                this.builder = Builder.createBuilder(this.context, a);
                this.builder.validateContext();
                if (this.builder.isAlreadyDone()) {
                    this.context.endAction();
                    continue;
                }
                this.context.startAction(a);
                try {
                    if (!this.builder.isFake()) {
                        this.builder.run();
                        this.builder.showStatistics();
                    }
                }
                catch (Exception e) {
                    this.context.taskAbort();
                    e.printStackTrace();
                }
                this.context.endAction();
            }
            this.context.setTaskRunning(false);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.context.error(e.getMessage());
            this.context.taskAbort();
        }
        finally {
            this.context.setTaskRunning(false);
            if (progressBar != null) {
                progressBar.end();
            }
        }
    }

    class ThreadProgressBar
    extends Thread {
        private Context context;
        boolean isRunning = true;
        long lastStat = -1L;
        long tempo;
        long lastGC = -1L;

        public ThreadProgressBar(Context context) {
            this.context = context;
            this.tempo = context instanceof ContextGui ? 1000L : 30000L;
        }

        @Override
        public void run() {
            while (this.isRunning) {
                try {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!this.isRunning || this.context.isTaskPause()) continue;
                    this.context.progressStatus();
                    long now = System.currentTimeMillis();
                    if (now - this.lastStat <= this.tempo || Task.this.builder == null) continue;
                    Task.this.builder.showStatistics();
                    this.lastStat = now;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.context.resumeWidgets();
        }

        public void end() {
            this.isRunning = false;
        }
    }
}

